<?php

/*
  Plugin Name: SWPM Reset Settings & Data
  Description: Simple Membership extension for resetting settings and deleting data.
  Plugin URI: https://simple-membership-plugin.com/simple-membership-reset-settings-and-data-addon/
  Author: smp7, wp.insider
  Author URI: https://simple-membership-plugin.com/
  Version: 1.0
 */

//Slug - swpm_rsd

//Direct access to this file is not permitted
if ( ! defined( 'ABSPATH' ) ) {
	exit; //Exit if accessed directly
}

//Define constants
define( 'SWPM_RSD_PLUGIN_VER', '1.0' );
define( 'SWPM_RSD_PLUGIN_URL', plugins_url( '', __FILE__ ) );
define( 'SWPM_RSD_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'SWPM_RSD_PLUGIN_FILE', __FILE__ );

require_once SWPM_RSD_PLUGIN_PATH . '/includes/class-swpm-rsd-data-handler.php';
require_once SWPM_RSD_PLUGIN_PATH . '/includes/class-swpm-rsd-admin.php';

if ( class_exists( 'SWPM_RSD_Admin' ) ) {
	// Initialize the admin dashboard side of this plugin.
	new SWPM_RSD_Admin();
}

function swpm_rsd_add_settings_link( $links, $file ) {
	if ( $file == plugin_basename( SWPM_RSD_PLUGIN_FILE ) ) {
		$settings_link = '<a href="options-general.php?page=swpm-reset-data">Settings</a>';
		array_unshift( $links, $settings_link );
	}

	return $links;
}

add_filter( 'plugin_action_links', 'swpm_rsd_add_settings_link', 10, 2 );