<?php

/**
 * Class used to communicate to the plugin's data in the database.
 */
class SWPM_RSD_Data_Handler {

	public static function reset_admin_settings() {
		// List of the options to delete.
		$options = array(
			'swpm-settings',
			'swpm-messages',
			'swpm_plugin_user_feedback_notice',
			'swpm_plugin_activated_time',
			'swpm_paypal_webhook_id_production',
			'swpm_paypal_webhook_id_sandbox',
			'cart_paypal_email',
			'swpm_paypal_webhook_id_production',
			'swpm_paypal_webhook_id_sandbox',
			'swpm_ppcp_connect_query_args_production',
			'swpm_ppcp_connect_query_args_sandbox',
			'swpm_private_key_one',
			'swpm_db_version',
		);

		/**
		 * TODO: There are some options with variable key name. This need to handle later.
		 *
		 * swpm_email_activation_lvl_$variable
		 * swpm_email_activation_data_usr_$variable
		 */

		foreach ( $options as $option ) {
			$does_exists = get_option( $option, false );
			if ( $does_exists !== false ) {
				delete_option( $option );
			}
		}

		return [
			'message'    => __( 'Simple Membership plugin settings were deleted successfully.', 'simple-membership' ),
			'status'     => 'success',
			'is_success' => true
		];
	}

	public static function reset_members_data() {
		global $wpdb;

		$is_success = $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . 'swpm_members_tbl' );
		if ( ! $is_success ) {
			return [
				'message'    => __( 'Simple Membership members data could not be deleted!.', 'simple-membership' ),
				'status'     => 'error',
				'is_success' => false
			];
		}

		$is_success = $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . 'swpm_members_meta_tbl' );
		if ( ! $is_success ) {
			return [
				'message'    => __( 'Simple Membership members meta data could not be deleted!.', 'simple-membership' ),
				'status'     => 'error',
				'is_success' => false
			];
		}

		return [
			'message'    => __( 'All Members data were deleted successfully.', 'simple-membership' ),
			'status'     => 'success',
			'is_success' => true
		];
	}

	public static function reset_membership_data() {
		global $wpdb;

		$is_success = $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . 'swpm_membership_tbl' );
		if ( ! $is_success ) {
			return [
				'message'    => __( 'Simple Membership membership data could not be deleted!.', 'simple-membership' ),
				'status'     => 'error',
				'is_success' => false
			];
		}

		$is_success = $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . 'swpm_membership_meta_tbl' );
		if ( ! $is_success ) {
			return [
				'message'    => __( 'Simple Membership membership meta data could not be deleted!.', 'simple-membership' ),
				'status'     => 'error',
				'is_success' => false
			];
		}

		return [
			'message'    => __( 'All membership related data were deleted successfully.', 'simple-membership' ),
			'status'     => 'success',
			'is_success' => true
		];
	}

	public static function reset_payments_data() {
		global $wpdb;

		$is_success = $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . 'swpm_payments_tbl' );
		if ( ! $is_success ) {
			return [
				'message'    => __( 'Simple Membership payments data could not be deleted!', 'simple-membership' ),
				'status'     => 'error',
				'is_success' => false
			];
		}

		// First, check if any records match
		$txn_count = $wpdb->get_var( "SELECT COUNT(*) FROM " . $wpdb->posts . " WHERE post_type = 'swpm_transactions'" );
		if ( $txn_count > 0 ) {
			// Delete custom post type with post meta.
			$is_success = $wpdb->query(
				"DELETE a,b 
						FROM $wpdb->posts a 
						LEFT JOIN $wpdb->postmeta b ON a.ID = b.post_id 
						WHERE a.post_type='swpm_transactions';"
			);
			if ( ! $is_success ) {
				return [
					'message'    => __( 'Simple Membership transactions data could not be deleted!.', 'simple-membership' ),
					'status'     => 'error',
					'is_success' => false
				];
			}
		}

		// First, check if any records match
		$payment_btn_count = $wpdb->get_var( "SELECT COUNT(*) FROM " . $wpdb->posts . " WHERE post_type = 'swpm_payment_button'" );
		if ( $payment_btn_count > 0 ) {
			// Delete custom post type with post meta.
			$is_success = $wpdb->query(
				"DELETE a,b 
						FROM $wpdb->posts a 
						LEFT JOIN $wpdb->postmeta b ON a.ID = b.post_id 
						WHERE a.post_type='swpm_payment_button';"
			);
			if ( ! $is_success ) {
				return [
					'message'    => __( 'Simple Membership payment button data could not be deleted!', 'simple-membership' ),
					'status'     => 'error',
					'is_success' => false
				];
			}
		}

		return [
			'message'    => __( 'All payments and transactions data were deleted successfully.', 'simple-membership' ),
			'status'     => 'success',
			'is_success' => true
		];
	}

	public static function reset_all() {
		$results = [];

		$results[] = self::reset_admin_settings();
		$results[] = self::reset_members_data();
		$results[] = self::reset_membership_data();
		$results[] = self::reset_payments_data();

		return $results;
	}
}
