<?php

/**
 * Handles the admin functionalities and views.
 */
class SWPM_RSD_Admin {

	private $core_plugin_file = 'simple-membership/simple-wp-membership.php';

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_admin_menus' ) );
	}

	public function add_admin_menus() {
		if ( function_exists( 'add_options_page' ) ) {
			add_options_page( 'Simple Membership Settings & Data Reset', 'SWPM Data Reset', 'manage_options', 'swpm-reset-data', array(
				$this,
				'reset_settings_page'
			) );
		}
	}

	/**
	 * Detects whether the core swpm plugin is active or not.
	 */
	public function is_core_plugin_active() {
		return is_plugin_active( $this->core_plugin_file );
	}

	/**
	 * Deactivates the Simple Membership core plugin.
	 */
	public function deactivate_core_plugin() {
		deactivate_plugins( $this->core_plugin_file );
	}

	/**
	 * Renders the settings page in the admin.
	 */
	public function reset_settings_page() {
		?>
        <div class="wrap">
            <h2>Simple Membership Reset Settings & Data</h2>
			<?php
			if ( $this->is_core_plugin_active() ) {
				if ( isset( $_POST['swpm_rsd_deactivate_swpm'] ) && check_admin_referer( 'swpm-rsd-deactivate-swpm-nonce' ) ) {
					// Deactivate the plugin
					$this->deactivate_core_plugin();
					// Redirect to the same page to reload the page with the deactivated plugin status.
					if ( method_exists( 'SwpmMiscUtils', 'redirect_to_url' ) ) {
						SwpmMiscUtils::redirect_to_url( admin_url( 'options-general.php?page=swpm-reset-data' ) );
					}
				} else {
					?>
                    <div class="notice notice-error">
                        <p>
							<span>
								<?php _e( 'You must deactivate the Simple Membership main plugin first to do the reset properly!', 'simple-membership' ) ?>
							</span>
                            <br>
                            <br>
                        <form action="" method="POST">
							<?php wp_nonce_field( 'swpm-rsd-deactivate-swpm-nonce' ); ?>
                            <button type="submit" name="swpm_rsd_deactivate_swpm" class="button-primary">
								<?php _e( 'Deactivate Simple Membership', 'simple-membership' ) ?>
                            </button>
                        </form>
                        </p>
                    </div>
					<?php
					return;
				}
			} ?>

            <div class="swpm_rsd_info_box">
                <p>
					<?php _e( 'You can use the Factory Reset option to reset all settings and data at once or choose to reset specific aspects of the plugin individually.', 'simple-membership' ); ?>
                </p>
            </div>

			<?php
			//Handle the form submissions
			if ( isset( $_POST['swpm_rsd_reset_all'] ) && check_admin_referer( 'swpm_rsd_reset_all_nonce' ) ) {

				$results = SWPM_RSD_Data_Handler::reset_all();

				foreach ( $results as $result ) {
					echo '<div class="notice notice-' . $result['status'] . '"><p>' . $result['message'] . '</p></div>';
				}
			}

			//Handle the form submissions
			if ( isset( $_POST['swpm_rsd_reset_members_data'] ) && check_admin_referer( 'swpm_rsd_reset_members_data_nonce' ) ) {

				$result = SWPM_RSD_Data_Handler::reset_members_data();

				echo '<div class="notice notice-' . esc_attr( $result['status'] ) . '"><p>' . esc_attr( $result['message'] ) . '</p></div>';
			}

			//Handle the form submissions
			if ( isset( $_POST['swpm_rsd_reset_membership_data'] ) && check_admin_referer( 'swpm_rsd_reset_membership_data_nonce' ) ) {

				$result = SWPM_RSD_Data_Handler::reset_membership_data();

				echo '<div class="notice notice-' . esc_attr( $result['status'] ) . '"><p>' . esc_attr( $result['message'] ) . '</p></div>';
			}

			//Handle the form submissions
			if ( isset( $_POST['swpm_rsd_reset_payments_data'] ) && check_admin_referer( 'swpm_rsd_reset_payments_data_nonce' ) ) {

				$result = SWPM_RSD_Data_Handler::reset_payments_data();

				echo '<div class="notice notice-' . esc_attr( $result['status'] ) . '"><p>' . esc_attr( $result['message'] ) . '</p></div>';
			}
			//Handle the form submissions
			if ( isset( $_POST['swpm_rsd_reset_admin_settings'] ) && check_admin_referer( 'swpm_rsd_reset_admin_settings_nonce' ) ) {

				$result = SWPM_RSD_Data_Handler::reset_admin_settings();

				echo '<div class="notice notice-' . esc_attr( $result['status'] ) . '"><p>' . esc_attr( $result['message'] ) . '</p></div>';
			}

			?>
            <style>
                .swpm_rsd_warning_box {
                    background: #FFF6D5;
                    border: 1px solid #D1B655;
                    color: #3F2502;
                    margin: 10px 0;
                    padding: 5px 5px 5px 10px;
                }

                .swpm_rsd_info_box {
                    background: #DDDDDD;
                    border: 1px solid #CFCFCF;
                    color: #363636;
                    margin: 10px 0px 15px 0px;
                    padding: 5px 5px 5px 10px;
                }
            </style>

			<?php
			$this->display_reset_all_form();
			$this->display_reset_members_data_form();
			$this->display_reset_membership_data_form();
			$this->display_reset_payments_data_form();
			$this->display_reset_admin_settings_form();
			?>
        </div><!-- end of wrap -->
		<?php
	}

	public function display_reset_all_form() {
		?>
        <div id="poststuff">
            <div id="post-body">
                <form action="" method="POST" id="swpm_rsd_reset_all"
                      onSubmit="if(!confirm('<?php _e( 'Are you sure?', 'simple-membership' ) ?>')){return false;}">
					<?php wp_nonce_field( 'swpm_rsd_reset_all_nonce' ); ?>
                    <div class="postbox">
                        <h3 class="hndle">
                            <label for="title"><?php _e( 'Factory Reset', 'simple-membership' ); ?></label>
                        </h3>
                        <div class="inside">
                            <div class="swpm_rsd_warning_box">
                                <p>
                                    <b>WARNING: </b>
                                    <span>
										<?php _e( 'This action will permanently delete all data and settings associated with the Simple Membership plugin! Proceed with caution.', 'simple-membership' ); ?>
									</span>
                                </p>
                            </div>
                            <button type="submit"
                                    class="button-primary"><?php _e( 'Reset Everything', 'simple-membership' ) ?></button>
                            <input type="hidden" name="swpm_rsd_reset_all"/>
                        </div>
                    </div>
                </form>
            </div>
        </div>
		<?php
	}

	public function display_reset_members_data_form() {
		?>
        <div id="poststuff">
            <div id="post-body">
                <form action="" method="POST" id="swpm_rsd_reset_members_data"
                      onSubmit="if(!confirm('<?php _e( 'Are you sure?', 'simple-membership' ) ?>')){return false;}">
					<?php wp_nonce_field( 'swpm_rsd_reset_members_data_nonce' ); ?>
                    <div class="postbox">
                        <h3 class="hndle">
                            <label for="title"><?php _e( 'Reset Members Data', 'simple-membership' ); ?></label>
                        </h3>
                        <div class="inside">
                            <div class="swpm_rsd_warning_box">
                                <p>
                                    <b>WARNING: </b>
                                    <span>
										<?php _e( 'This will erase all members and their meta data of the Simple Membership plugin!', 'simple-membership' ); ?>
									</span>
                                </p>
                            </div>
                            <button type="submit"
                                    class="button-primary"><?php _e( 'Reset', 'simple-membership' ) ?></button>
                            <input type="hidden" name="swpm_rsd_reset_members_data"/>
                        </div>
                    </div>
                </form>
            </div>
        </div>
		<?php
	}

	public function display_reset_membership_data_form() {
		?>
        <div id="poststuff">
            <div id="post-body">
                <form action="" method="POST" id="swpm_rsd_reset_membership_data"
                      onSubmit="if(!confirm('<?php _e( 'Are you sure?', 'simple-membership' ) ?>')){return false;}">
					<?php wp_nonce_field( 'swpm_rsd_reset_membership_data_nonce' ); ?>
                    <div class="postbox">
                        <h3 class="hndle">
                            <label for="title"><?php _e( 'Reset Membership Level Data', 'simple-membership' ); ?></label>
                        </h3>
                        <div class="inside">
                            <div class="swpm_rsd_warning_box">
                                <p>
                                    <b>WARNING: </b>
                                    <span>
										<?php _e( 'This will erase all membership level related data of the Simple Membership plugin!', 'simple-membership' ); ?>
									</span>
                                </p>
                            </div>
                            <button type="submit"
                                    class="button-primary"><?php _e( 'Reset', 'simple-membership' ) ?></button>
                            <input type="hidden" name="swpm_rsd_reset_membership_data"/>
                        </div>
                    </div>
                </form>
            </div>
        </div>
		<?php
	}

	public function display_reset_payments_data_form() {
		?>
        <div id="poststuff">
            <div id="post-body">
                <form action="" method="POST" id="swpm_rsd_reset_payments_data"
                      onSubmit="if(!confirm('<?php _e( 'Are you sure?', 'simple-membership' ) ?>')){return false;}">
					<?php wp_nonce_field( 'swpm_rsd_reset_payments_data_nonce' ); ?>
                    <div class="postbox">
                        <h3 class="hndle">
                            <label for="title"><?php _e( 'Reset Payments & Transactions Data', 'simple-membership' ); ?></label>
                        </h3>
                        <div class="inside">
                            <div class="swpm_rsd_warning_box">
                                <p>
                                    <b>WARNING: </b>
                                    <span>
										<?php _e( 'This will erase all payments related data of the Simple Membership plugin!', 'simple-membership' ); ?>
									</span>
                                </p>
                            </div>
                            <button type="submit"
                                    class="button-primary"><?php _e( 'Reset', 'simple-membership' ) ?></button>
                            <input type="hidden" name="swpm_rsd_reset_payments_data"/>
                        </div>
                    </div>
                </form>
            </div>
        </div>
		<?php
	}

	public function display_reset_admin_settings_form() {
		?>
        <div id="poststuff">
            <div id="post-body">
                <form action="" method="POST" id="swpm_rsd_reset_admin_settings"
                      onSubmit="if(!confirm('<?php _e( 'Are you sure?', 'simple-membership' ) ?>')){return false;}">
					<?php wp_nonce_field( 'swpm_rsd_reset_admin_settings_nonce' ); ?>
                    <div class="postbox">
                        <h3 class="hndle">
                            <label for="title"><?php _e( 'Reset Admin Settings', 'simple-membership' ); ?></label>
                        </h3>
                        <div class="inside">
                            <div class="swpm_rsd_warning_box">
                                <p>
                                    <b>WARNING: </b>
                                    <span>
										<?php _e( 'This will erase all admin settings of the Simple Membership plugin!', 'simple-membership' ); ?>
									</span>
                                </p>
                            </div>
                            <button type="submit"
                                    class="button-primary"><?php _e( 'Reset', 'simple-membership' ) ?></button>
                            <input type="hidden" name="swpm_rsd_reset_admin_settings"/>
                        </div>
                    </div>
                </form>
            </div>
        </div>
		<?php
	}
}
