<?php
/*
  Plugin Name: Simple Membership API
  Version: 2.2
  Plugin URI: https://simple-membership-plugin.com/
  Author: alexanderfoxc, wp.insider
  Author URI: https://simple-membership-plugin.com/
  Description: API add-on for the Simple Membership plugin.
 */

 //Slug - swpm_api_

//Direct access to this file is not permitted
if ( ! defined( 'ABSPATH' ) ) {
    exit; //Exit if accessed directly
}

define( 'SWPM_API_ADDON_PATH', dirname( __FILE__ ) . '/' );
define( 'SWPM_API_ADDON_URL', plugins_url( '', __FILE__ ) );

//Load the necessary files
require_once ( SWPM_API_ADDON_PATH .'classes/class.swpm-api-settings.php');

/**************************************************************************************/
//Certain API queries require functions from the main plugin. 
//We handle any API endpoint requests in 'init' hook to ensure that the main plugin has been loaded.
/**************************************************************************************/
function swpm_api_init_times_tasks() {
    //The classes should be loaded by now but we will keep a check just in case.
    if ( class_exists( 'SimpleWpMembership' ) && class_exists( 'SwpmRegistration' ) ) {
        
        require_once ( SWPM_API_ADDON_PATH .'classes/class.swpm-api-profile-endpoints.php');
        require_once ( SWPM_API_ADDON_PATH .'classes/class.swpm-api-misc-endpoints.php'); 

        //Handle the Profile endpoints
        $swpm_profile_endpoints = new SWPM_API_Profile_Endpoints();
        $swpm_profile_endpoints->handle_api_req();

        //Handle the Misc endpoints
        $swpm_misc_endpoints = new SWPM_API_Misc_Endpoints();
        $swpm_misc_endpoints->handle_misc_endpoints();
    
    }
}
add_action( 'init', "swpm_api_init_times_tasks" );

//Handle the settings interface of this addon.
new SWPM_API_Settings();

//Add settings link in the plugins listing page
function swpm_api_add_settings_link( $links, $file ) {
	if ( $file == plugin_basename( __FILE__ ) ) {
		$settings_link = '<a href="admin.php?page=simple_wp_membership_settings&tab=7">Settings</a>';
		array_unshift( $links, $settings_link );
	}
	return $links;
}
add_filter( 'plugin_action_links', 'swpm_api_add_settings_link', 10, 2 );