<?php

class SWPM_API_Settings {

	public function __construct() {
        //This hooks are triggered from the main plugin's settings interface. 
        //So we can expect the classes and methods from the main plugin to be available.
		add_action( 'swpm_addon_settings_section', array(&$this, 'settings_ui' ) );
		add_action( 'swpm_addon_settings_save', array(&$this, 'settings_save' ) );
	}

	function settings_ui() {
		$settings = SwpmSettings::get_instance();
		$enable_api = $settings->get_value( 'swpm-addon-enable-api' );
		$api_key = $settings->get_value( 'swpm-addon-api-key' );
		if ( ! $api_key ) {
			$api_key = md5( uniqid() );
			$settings->set_value( 'swpm-addon-api-key', sanitize_text_field( $api_key ) );
			$settings->save();
		}
        // Render the settings view
		require_once ( SWPM_API_ADDON_PATH . 'views/settings.php' );
	}

	function settings_save() {
		$message = array( 'succeeded' => true, 'message' => '<p>' . BUtils::_( 'Settings updated!' ) . '</p>' );
		SwpmTransfer::get_instance()->set( 'status', $message );
		$enable_api = filter_input( INPUT_POST, 'swpm-addon-enable-api' );
		$api_key = filter_input( INPUT_POST, 'swpm-addon-api-key' );

		$settings = SwpmSettings::get_instance();
		$settings->set_value( 'swpm-addon-enable-api', empty( $enable_api ) ? "" : $enable_api );
		$settings->set_value( 'swpm-addon-api-key', sanitize_text_field( $api_key ) );
		$settings->save();
	}

}