<?php

/*
* This class handles the following API requests:
* - login
*/
class SWPM_API_Misc_Endpoints {

	public function __construct() {
		// Nothing to do here.
	}

	public static function post_reply( $reply, $success = true ) {
		if ( $success ) {
			$res = 'success';
		} else {
			$res = 'failure';
		}
		$reply = array( 'result' => $res ) + $reply;
		ob_end_clean();
		echo json_encode( $reply );
		die( 0 );
	}

	public function handle_misc_endpoints() {
		//Basic checks
		if ( ! isset( $_REQUEST['swpm_api_action'] ) ) {
			//this is not API request. Aborting.
			return false;
		}

		$reply = array();
		$action = $_REQUEST['swpm_api_action'];

		//check if API is enabled
		$settings = SwpmSettings::get_instance();
		if ( ! $settings->get_value( 'swpm-addon-enable-api' ) ) {
			//API disabled in the settings.
			return false;
		}

		if ( ! isset( $_REQUEST['key'] ) ) {
			$reply['message'] = "No API key provided";
			SWPM_API_Misc_Endpoints::post_reply( $reply, false );
		}

		$api_key = $settings->get_value( 'swpm-addon-api-key' );

		if ( $api_key !== $_REQUEST['key'] ) {
			//invalid API key
			$reply['message'] = "Invalid API key";
			SWPM_API_Misc_Endpoints::post_reply( $reply, false );
		}

		//Handle the API requests

		/**************************************/
		//Handle the 'login' request.
		/**************************************/
		if ( $action === 'login' ) {
			/************************************************************/
			//The 'login' request can be an HTTP POST or GET request.
			/************************************************************/
			SwpmLog::log_simple_debug( 'SWPM API addon: login action request received. Additional details can be found in the login debug file.', true );
			$auth = SwpmAuth::get_instance();
			$username = isset($_REQUEST['username']) ? sanitize_user($_REQUEST['username']) : '';
			$password = isset($_REQUEST['password']) ? $_REQUEST['password'] : '';
			$remember = isset($_REQUEST['remember']) ? true : false;

			//Check if the member is already logged in.
			if ( $auth->is_logged_in() ) {
				$reply['message'] = "The member is already logged in. Nothing to do.";
				SWPM_API_Misc_Endpoints::post_reply( $reply );
			}

			//Attempt to log the member in.
			$login_result = $auth->login( $username, $password, $remember );
			/****************************/
			//NOTE: for a successful login, the login() method will redirect the user to the appropriate page. So the following code will not be executed for a successful login.
			/****************************/
			$reply['message'] = "The login action result: " . $login_result;
			SWPM_API_Misc_Endpoints::post_reply( $reply );

		}//End of 'login' request handling.


	}//End of handle_misc_endpoints().

}